
package picounit.framework;

/**
 * An abstract test case which is to be subclassed for a real testing.
 * 
 * @author  Jian Hu
 */
public abstract class TestCase implements Test {

    
    private String name;
    
    /**
     * Constructor
     */
    
    public TestCase(String name) {
        this.name = name;
    }
    
    /**
     * To be overridden by subclass
     */
    public void run() {
    }
    
    /**
     * Prints failure message if this test (represented by 
     * 'condition') fails
     */
    
    protected void printFailure(boolean condition) {
        if (!condition) {
            System.out.println("Failed: " + toString());
        }
    }

    /**
     * Returns the test name
     * @return String test name
     */
    
    public String getName() {
        return this.name;
    }
    
    /**
     * Returns the representation of this test
     * @return String the test representation
     */
    
    public String toString() {
        return this.name;
    }
}
