
package picounit.framework;

import java.util.Vector;
import java.util.Enumeration;

/**
 * A suite containing a set of tests.
 * @author  Jian Hu
 */
public class TestSuite implements Test {
    
    private String name;
    private Vector tests = new Vector(10);

    /** Constructor
     */
    public TestSuite() {
    }
    
    /**
     * Constructs an empty TestSuite.
     */
    public TestSuite(String name) {
        this.name = name;
    }

    /**
     * Runs a set of tests
     */
    
    public void run() {
        for (Enumeration e= this.tests.elements(); e.hasMoreElements(); ) {
            Test test= (Test)e.nextElement();
            test.run();
        }
    }


    /**
     * Adds a test to the suite.
     */
    public void addTest(Test test) {
        tests.addElement(test);
    }
    
    /**
     * Returns a string representation of this TestSuite
     */
    
    public String toString() {
        if (this.name == null) {
            return super.toString();
        } else {
            return this.name;
        }
    }
}
