package picounit.samples.money;

/**
 * A simple Money.
 *
 */
public class Money {

    private int amount;
    private String currency;

    /**
     * Constructs a money from the given amount and currency.
     */
    public Money(int amount, String currency) {
        this.amount= amount;
        this.currency= currency;
    }

    public Money add(Money m) {
        if (m.currency().equals(currency()) )
            return new Money(amount() + m.amount(), currency());
        return null;
    }


    public int amount() {
        return this.amount;
    }

    public String currency() {
        return this.currency;
    }

    public boolean isZero() {
        return amount() == 0;
    }
    
    public Money multiply(int factor) {
        return new Money(amount()*factor, currency());
    }
    
    public Money negate() {
        return new Money(-amount(), currency());
    }
    
    public Money subtract(Money m) {
        return add(m.negate());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("["+amount()+" "+currency()+"]");
        return buffer.toString();
    }

    public boolean equals(Object anObject) {
        if (isZero()) 
            if (anObject instanceof Money)
                return ((Money)anObject).isZero();
        if (anObject instanceof Money) {
            Money aMoney= (Money)anObject;
            return aMoney.currency().equals(currency())
                    && amount() == aMoney.amount();
        }
        return false;
    }
    
    public int hashCode() {
        return this.currency.hashCode() + this.amount;
    }
}