package picounit.samples.phone;


/**
 * A simple phone number. This class formulates a phone
 * number representation.
 *
 */
public class PhoneNumber {

    private String areaCode;
    private String number;

    /**
     * Constructor
     */
    public PhoneNumber(String areaCode, String number) {
        this.areaCode = areaCode;
        this.number = number;
    }
    
    /**
     * Formulates a phone number representation
     * @return String a string of format like (131) 7891234
     *   or "--" if either area code or number is null
     */
    public String getFullNumber() {
        if (this.areaCode != null && this.number != null) {
            return "(" + areaCode + ") " + number;
        } else {
            return "--";
        }
    }
}