
package picounit.samples.money;

import picounit.framework.*;

public class MoneyTest {

    public static TestSuite suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(new TestZero());
        suite.addTest(new TestAdd());
        return suite;
    }
    
    public static void main(String args[]) {
        
        System.out.println("Start running ...");
        suite().run();
        System.out.println("end running ...");
    }
    
}

class TestZero extends TestCase {
    public TestZero() {
        super("TestZero");
    }

    public void run() {
        Money f12USD= new Money(12, "USD");
        printFailure(f12USD.subtract(f12USD).isZero());
    }
}

class TestAdd extends TestCase {
    public TestAdd() {
        super("TestAdd");
    }

    public void run() {
        Money f12USD= new Money(12, "USD");
        Money f14USD= new Money(14, "USD");
        Money expected = new Money(260, "USD");
        
        printFailure(f12USD.add(f14USD).equals(expected));
    }
}