package picounit.samples.phone;

import picounit.framework.*;

public class PhoneNumberTest {

    public static TestSuite suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(new TestNullAreaCode());
        suite.addTest(new TestNotNull());
        return suite;
    }
    
    public static void main(String args[]) {
        
        System.out.println("Start running ...");
        suite().run();
        System.out.println("end running ...");
    }
    
}

class TestNullAreaCode extends TestCase {
    public TestNullAreaCode() {
        super("TestNullAreaCode");
    }

    public void run() {
        PhoneNumber phoneNo = new PhoneNumber(null, "7934931");
        printFailure(phoneNo.getFullNumber().equals("Invalid Number"));
    }
}

class TestNotNull extends TestCase {
    public TestNotNull() {
        super("TestNotNull");
    }

    public void run() {
        PhoneNumber phoneNo = new PhoneNumber("131", "7934931");
        printFailure(phoneNo.getFullNumber().equals("(131) 7934931"));
    }
}